/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_probe.c,v 1.10 2005/06/29 00:23:16 eugene Exp $";

#include <sys/time.h>
#include <stdio.h>
#include <pthread.h>
#include <errno.h>
#include "mx_auto_config.h"
#include "myriexpress.h"
#include "internal.h"

mx_return_t 
mx_probe(mx_endpoint_t endpoint, 
	 uint32_t timeout,
	 uint64_t match_info,
	 uint64_t match_mask,
	 mx_status_t *status,
	 uint32_t *result)
{
  
  struct mx_queued_msg *msg;
  uint32_t mask_value;
  int rs;
  struct timespec ts;
  struct timeval  tv;

  MX_DEBUG_PRINT(MX_DEBUG_TCP_LIB,("probe: 0x%08x%08x:0x%08x%08x\n", 
            MX_U32(match_info), MX_L32(match_info), MX_U32(match_mask), MX_L32(match_mask)));
  
  pthread_mutex_lock(&Mx_rx_lock);

  for(msg = endpoint->queued_messages.next;
      msg != &endpoint->queued_messages;
      msg = msg->next){
    if (((msg->match_info & match_mask) == match_info) &&
        ((msg->type == MX_SR_TYPE_SEND) || 
         (msg->type == MX_SR_TYPE_ISSEND))){
      if (status != NULL){
        status->source = msg->source;
        status->msg_length = msg->length;
	status->match_info = msg->match_info;
      }
      *result = 1;
      pthread_mutex_unlock(&Mx_rx_lock);
      return MX_SUCCESS;
    }
  }

  gettimeofday(&tv, NULL);
  ts.tv_sec = tv.tv_sec + timeout/1000;
  ts.tv_nsec = tv.tv_usec * 1000 + 
    (timeout % 1000) * 1000 * 1000;
  rs = pthread_cond_timedwait(&endpoint->probe_cond, 
                              &Mx_rx_lock, &ts);
  if (rs == ETIMEDOUT){
    pthread_mutex_unlock(&Mx_rx_lock);
    *result = 0;
    return MX_SUCCESS;
  }

  msg = endpoint->queued_messages.next;
  if(msg == &endpoint->queued_messages){
    pthread_mutex_unlock(&Mx_rx_lock);
    MX_DEBUG_PRINT(MX_DEBUG_TCP_LIB,("mx_probe: no queued message\n"));
    return MX_FAILURE;
  }

  if (status != NULL){
    status->source = msg->source;
    status->msg_length = msg->length;
    status->match_info = msg->match_info;
  }
  *result = 1;
  pthread_mutex_unlock(&Mx_rx_lock);

  return MX_SUCCESS;
}
